/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// CSecDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "CSecDialog.h"

#include "funcheader.h"
#include "section.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCSecDialog dialog


CCSecDialog::CCSecDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CCSecDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCSecDialog)
	m_cLength = 0.0;
	m_cThickness = 0.0;
	m_cWidth = 0.0;
	m_cExtHeight = 0.0;
	m_blendRadius = 0.0;
	m_check1 = FALSE;
	//}}AFX_DATA_INIT
}


void CCSecDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCSecDialog)
	DDX_Text(pDX, IDC_CEDIT1, m_cLength);
	DDX_Text(pDX, IDC_CEDIT2, m_cThickness);
	DDX_Text(pDX, IDC_CEDIT3, m_cWidth);
	DDX_Text(pDX, IDC_CEDIT4, m_cExtHeight);
	DDX_Text(pDX, IDC_CEDIT5, m_blendRadius);
//	DDV_MinMaxDouble(pDX, m_blendRadius, 1.e-004, 1000.);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCSecDialog, CDialog)
	//{{AFX_MSG_MAP(CCSecDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCSecDialog message handlers

void CCSecDialog::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	ISet *objset1 = NULL;
	UpdateData(TRUE);

	if(!m_check1)
		m_blendRadius = 0.0;

	if(m_cLength >0 && m_cThickness > 0 && m_cWidth > 0 && m_cExtHeight > 0
		&& m_cThickness < m_cLength && m_cThickness < m_cWidth) {
		
		status = CreateCSection(m_cLength/1000, m_cThickness/1000, m_cWidth/1000, m_cExtHeight/1000,
			m_blendRadius/1000,&objset1);

		if(status || !objset1){
			AfxMessageBox("CreateCSection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");

	CDialog::OnOK();
}
